/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.configuration;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.data.web.HateoasSortHandlerMethodArgumentResolver;
import org.springframework.data.web.config.HateoasAwareSpringDataWebConfiguration;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.ResourceProcessor;
import org.springframework.hateoas.hal.CurieProvider;
import org.springframework.hateoas.hal.Jackson2HalModule;
import org.springframework.hateoas.mvc.ResourceProcessorInvoker;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewInterceptor;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.JsonViewRequestBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.JsonViewResponseBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import org.squashtest.tm.plugin.rest.core.configuration.RestApiProperties;
import org.squashtest.tm.plugin.rest.core.configuration.SquashRestApiJacksonModule;
import org.squashtest.tm.plugin.rest.core.configuration.SquashRestApiJacksonModuleConfigurer;
import org.squashtest.tm.plugin.rest.core.jackson.EntityManagerWrapper;
import org.squashtest.tm.plugin.rest.core.jackson.ModuleExclusionObjectMapper;
import org.squashtest.tm.plugin.rest.core.jackson.PersistentValueInstantiators;
import org.squashtest.tm.plugin.rest.core.jackson.SquashRestHalHandlerInstantiator;
import org.squashtest.tm.plugin.rest.core.service.NodeHierarchyHelpService;
import org.squashtest.tm.plugin.rest.core.service.impl.NodeHierarchyHelpServiceImpl;
import org.squashtest.tm.plugin.rest.core.utils.DeserializationConfigHelper;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.BasicResourceAssembler;
import org.squashtest.tm.plugin.rest.core.web.ContentInclusionArgumentResolver;
import org.squashtest.tm.plugin.rest.core.web.DeserializationConfigurationRequestBodyAdvice;
import org.squashtest.tm.plugin.rest.core.web.DisableableSortResolver;
import org.squashtest.tm.plugin.rest.core.web.DynamicFilterResponseBodyAdvice;
import org.squashtest.tm.plugin.rest.core.web.PersistentEntityArgumentResolver;
import org.squashtest.tm.plugin.rest.core.web.PersistentEntityJacksonHttpMessageConverter;
import org.squashtest.tm.plugin.rest.core.web.RestApiExceptionHandler;
import org.squashtest.tm.plugin.rest.core.web.RestApiHandlerAdapter;
import org.squashtest.tm.plugin.rest.core.web.RestApiHandlerMapping;
import org.squashtest.tm.plugin.rest.core.web.RestApiRelProvider;

@Configuration
@EnableConfigurationProperties(value={RestApiProperties.class})
public class ApiWebConfig
extends HateoasAwareSpringDataWebConfiguration {
    @Autowired(required=false)
    private Collection<ResourceProcessor<?>> resourceProcessors = new ArrayList();
    @Inject
    private ApplicationContext appContext;
    @Inject
    private Jackson2ObjectMapperBuilder objectMapperBuilder;
    @Autowired
    private Collection<SquashRestApiJacksonModuleConfigurer> jacksonConfigurers;
    @Autowired(required=false)
    private CurieProvider curieProvider;
    private final Map<String, Object> memoizeMap = new HashMap<String, Object>();

    public ApiWebConfig(ApplicationContext context, @Qualifier(value="mvcConversionService") ObjectFactory<ConversionService> conversionService) {
        super(context, conversionService);
    }

    @Bean
    public RelProvider relProvider() {
        return new RestApiRelProvider();
    }

    @Bean
    public EntityManagerWrapper entityManagerWrapper() {
        return new EntityManagerWrapper();
    }

    @Bean
    public NodeHierarchyHelpService nodeHierarchyHelpService() {
        return new NodeHierarchyHelpServiceImpl();
    }

    @Bean
    public HandlerMapping squashRestHandlerMapping(RestApiProperties properties, EntityManagerFactory emf) {
        RestApiHandlerMapping mapping = new RestApiHandlerMapping(properties);
        mapping.addInterceptor(this.squashRestEntityManagerInViewInterceptor(emf));
        mapping.setOrder(2147482647);
        return mapping;
    }

    @Bean
    public RequestMappingHandlerAdapter squashRestHandlerAdapter() {
        ConfigurableWebBindingInitializer initializer = new ConfigurableWebBindingInitializer();
        initializer.setConversionService((ConversionService)this.squashRestConversionService());
        RestApiHandlerAdapter handlerAdapter = new RestApiHandlerAdapter(this.squashRestResourceProcessorInvoker());
        handlerAdapter.setCustomArgumentResolvers(this.squashRestArgumentResolvers());
        handlerAdapter.setWebBindingInitializer((WebBindingInitializer)initializer);
        handlerAdapter.setMessageConverters(this.squashRestMessageConverters());
        handlerAdapter.setRequestBodyAdvice(this.requestBodyAdvices());
        handlerAdapter.setResponseBodyAdvice(this.responseBodyAdvices());
        return handlerAdapter;
    }

    @Bean
    public BasePathAwareLinkBuildingService linkService(ServletContext servletContext, RestApiProperties properties) throws Exception {
        return new BasePathAwareLinkBuildingService(servletContext, properties, this.relProvider(), this.appContext);
    }

    @Bean
    public ExceptionHandlerExceptionResolver squashRestExceptionResolver() {
        ExceptionHandlerExceptionResolver resolver = new ExceptionHandlerExceptionResolver();
        resolver.setMappedHandlerClasses(new Class[]{BaseRestController.class});
        resolver.setCustomArgumentResolvers(this.squashRestArgumentResolvers());
        resolver.setMessageConverters(this.squashRestMessageConverters());
        return resolver;
    }

    @Bean
    public RestApiExceptionHandler squashRestExceptionHandler() {
        return new RestApiExceptionHandler();
    }

    protected List<HandlerMethodArgumentResolver> squashRestArgumentResolvers() {
        return this.memoized("squashRestArgumentResolvers", new PrivateBeanCreator<List<HandlerMethodArgumentResolver>>(){

            @Override
            public List<HandlerMethodArgumentResolver> create() {
                ArrayList<HandlerMethodArgumentResolver> argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
                HateoasPageableHandlerMethodArgumentResolver pageableResolver = ApiWebConfig.this.pageableResolver();
                HateoasSortHandlerMethodArgumentResolver sortResovler = ApiWebConfig.this.sortResolver();
                ContentInclusionArgumentResolver includeResolver = new ContentInclusionArgumentResolver();
                PersistentEntityArgumentResolver persistenEntityResolver = new PersistentEntityArgumentResolver(ApiWebConfig.this.squashRestMessageConverters(), ApiWebConfig.this.requestBodyAdvices());
                persistenEntityResolver.setConfigHelper(ApiWebConfig.this.deserializationConfigHelper());
                argumentResolvers.add((HandlerMethodArgumentResolver)pageableResolver);
                argumentResolvers.add((HandlerMethodArgumentResolver)sortResovler);
                argumentResolvers.add(includeResolver);
                argumentResolvers.add((HandlerMethodArgumentResolver)persistenEntityResolver);
                return argumentResolvers;
            }
        });
    }

    @Bean
    public HateoasSortHandlerMethodArgumentResolver sortResolver() {
        return new DisableableSortResolver();
    }

    protected WebRequestInterceptor squashRestEntityManagerInViewInterceptor(EntityManagerFactory emf) {
        OpenEntityManagerInViewInterceptor interceptor = new OpenEntityManagerInViewInterceptor();
        interceptor.setEntityManagerFactory(emf);
        return interceptor;
    }

    protected List<RequestBodyAdvice> requestBodyAdvices() {
        return this.memoized("requestBodyAdvices", new PrivateBeanCreator<List<RequestBodyAdvice>>(){

            @Override
            public List<RequestBodyAdvice> create() {
                ArrayList<RequestBodyAdvice> requestBodyAdvices = new ArrayList<RequestBodyAdvice>();
                requestBodyAdvices.add((RequestBodyAdvice)new JsonViewRequestBodyAdvice());
                requestBodyAdvices.add((RequestBodyAdvice)new DeserializationConfigurationRequestBodyAdvice());
                return requestBodyAdvices;
            }
        });
    }

    protected List<ResponseBodyAdvice<?>> responseBodyAdvices() {
        return (List)this.memoized("responseBodyAdvices", new PrivateBeanCreator<List<ResponseBodyAdvice<?>>>(){

            @Override
            public List<ResponseBodyAdvice<?>> create() {
                ArrayList responseBodyAdvices = new ArrayList();
                responseBodyAdvices.add((ResponseBodyAdvice<?>)new JsonViewResponseBodyAdvice());
                responseBodyAdvices.add((ResponseBodyAdvice<?>)new DynamicFilterResponseBodyAdvice());
                return responseBodyAdvices;
            }
        });
    }

    protected DeserializationConfigHelper deserializationConfigHelper() {
        return this.memoized("deserializationConfigHelper", new PrivateBeanCreator<DeserializationConfigHelper>(){

            @Override
            public DeserializationConfigHelper create() {
                return new DeserializationConfigHelper(ApiWebConfig.this.entityManagerWrapper(), ApiWebConfig.this.nodeHierarchyHelpService());
            }
        });
    }

    protected List<HttpMessageConverter<?>> squashRestMessageConverters() {
        return (List)this.memoized("squashRestMessageConverters", new PrivateBeanCreator<List<HttpMessageConverter<?>>>(){

            @Override
            public List<HttpMessageConverter<?>> create() {
                ArrayList converters = new ArrayList();
                converters.add((HttpMessageConverter<?>)ApiWebConfig.this.restHttpMessageConverter());
                converters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
                return converters;
            }
        });
    }

    protected ObjectMapper basicRestObjectMapper() {
        return this.memoized("basicRestObjectMapper", new PrivateBeanCreator<ObjectMapper>(){

            @Override
            public ObjectMapper create() {
                ModuleExclusionObjectMapper mapper = new ModuleExclusionObjectMapper();
                mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                mapper.configure(SerializationFeature.FAIL_ON_UNWRAPPED_TYPE_IDENTIFIERS, false);
                mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
                mapper.setDateFormat((DateFormat)new StdDateFormat());
                ApiWebConfig.this.objectMapperBuilder.configure((ObjectMapper)mapper);
                mapper.registerModule((Module)new Jackson2HalModule());
                ArrayList<SquashRestApiJacksonModuleConfigurer> configurers = new ArrayList<SquashRestApiJacksonModuleConfigurer>();
                configurers.addAll(ApiWebConfig.this.jacksonConfigurers);
                configurers.add(new SquashRestApiJacksonModuleConfigurer(){

                    @Override
                    public void setupModule(Module.SetupContext context) {
                        context.addValueInstantiators((ValueInstantiators)ApiWebConfig.this.persistentValueInstantiators());
                    }
                });
                mapper.registerModule((Module)new SquashRestApiJacksonModule(configurers));
                mapper.setHandlerInstantiator(ApiWebConfig.this.restHandlerInstantiator());
                return mapper;
            }
        });
    }

    public PersistentValueInstantiators persistentValueInstantiators() {
        return this.memoized("persistentValueInstantiators", new PrivateBeanCreator<PersistentValueInstantiators>(){

            @Override
            public PersistentValueInstantiators create() {
                return new PersistentValueInstantiators(ApiWebConfig.this.entityManagerWrapper());
            }
        });
    }

    protected MappingJackson2HttpMessageConverter restHttpMessageConverter() {
        return this.memoized("restHttpMessageConverter", new PrivateBeanCreator<MappingJackson2HttpMessageConverter>(){

            @Override
            public MappingJackson2HttpMessageConverter create() {
                ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
                mediaTypes.add(ApiWebConfig.mediaType("application/json"));
                PersistentEntityJacksonHttpMessageConverter converter = new PersistentEntityJacksonHttpMessageConverter();
                converter.setObjectMapper(ApiWebConfig.this.basicRestObjectMapper());
                converter.setSupportedMediaTypes(mediaTypes);
                return converter;
            }
        });
    }

    protected HandlerInstantiator restHandlerInstantiator() {
        return this.memoized("restHandlerInstantiator", () -> new SquashRestHalHandlerInstantiator(this.relProvider(), this.curieProvider, this.resourceDescriptionMessageSourceAccessor(), this.appContext.getAutowireCapableBeanFactory()));
    }

    public MessageSourceAccessor resourceDescriptionMessageSourceAccessor() {
        return null;
    }

    @Bean
    public BasicResourceAssembler squashRestResourceAssembler() {
        return this.memoized("squashRestResourceAssembler", new PrivateBeanCreator<BasicResourceAssembler>(){

            @Override
            public BasicResourceAssembler create() {
                return new BasicResourceAssembler();
            }
        });
    }

    protected DefaultFormattingConversionService squashRestConversionService() {
        return this.memoized("squashRestConversionService", new PrivateBeanCreator<DefaultFormattingConversionService>(){

            @Override
            public DefaultFormattingConversionService create() {
                DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
                return conversionService;
            }
        });
    }

    protected ResourceProcessorInvoker squashRestResourceProcessorInvoker() {
        return this.memoized("squashRestResourceProcessorInvoker", new PrivateBeanCreator<ResourceProcessorInvoker>(){

            @Override
            public ResourceProcessorInvoker create() {
                return new ResourceProcessorInvoker(ApiWebConfig.this.resourceProcessors);
            }
        });
    }

    private static final MediaType mediaType(String mtype) {
        return MediaType.valueOf((String)mtype);
    }

    private <T> T memoized(String key, PrivateBeanCreator<T> creator) {
        if (!this.memoizeMap.containsKey(key)) {
            T bean = creator.create();
            this.memoizeMap.put(key, bean);
        }
        return (T)this.memoizeMap.get(key);
    }

    @FunctionalInterface
    private static interface PrivateBeanCreator<T> {
        public T create();
    }
}

