/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.validation.AbstractBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationHints;
import org.squashtest.tm.plugin.rest.core.utils.DeserializationConfigHelper;
import org.squashtest.tm.plugin.rest.core.validation.HintedValidator;
import org.squashtest.tm.plugin.rest.core.web.ContextualizedMethodParameter;
import org.squashtest.tm.plugin.rest.core.web.PersistentEntity;

public class PersistentEntityArgumentResolver
extends AbstractMessageConverterMethodArgumentResolver {
    private DeserializationConfigHelper helper;

    public PersistentEntityArgumentResolver(List<HttpMessageConverter<?>> converters, List<RequestBodyAdvice> requestResponseBodyAdvice) {
        super(converters, requestResponseBodyAdvice);
    }

    public void setConfigHelper(DeserializationConfigHelper helper) {
        this.helper = helper;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(PersistentEntity.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        DeserializationHints hints = this.helper.createHints(servletRequest, parameter);
        ContextualizedMethodParameter contextualizedParam = new ContextualizedMethodParameter(parameter, hints);
        Object arg = this.readWithMessageConverters(webRequest, contextualizedParam, parameter.getGenericParameterType());
        String modelName = Conventions.getVariableNameForParameter((MethodParameter)parameter);
        WebDataBinder binder = binderFactory.createBinder(webRequest, arg, modelName);
        if (arg != null) {
            this.mergeBindingResults(binder, hints);
            this.validateIfApplicable(binder, contextualizedParam);
            if (binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
                throw new MethodArgumentNotValidException(parameter, binder.getBindingResult());
            }
        }
        mavContainer.addAttribute(String.valueOf(BindingResult.MODEL_KEY_PREFIX) + modelName, (Object)binder.getBindingResult());
        return arg;
    }

    protected <T> Object readWithMessageConverters(NativeWebRequest webRequest, MethodParameter methodParam, Type paramType) throws IOException, HttpMediaTypeNotSupportedException, HttpMessageNotReadableException {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        ServletServerHttpRequest inputMessage = new ServletServerHttpRequest(servletRequest);
        Object arg = this.readWithMessageConverters((HttpInputMessage)inputMessage, methodParam, paramType);
        return arg;
    }

    private void mergeBindingResults(WebDataBinder binder, DeserializationHints hints) {
        AbstractBindingResult deserializationResult = hints.getBindingResult();
        BindingResult binderResult = binder.getBindingResult();
        for (ObjectError err : deserializationResult.getAllErrors()) {
            binderResult.addError(err);
        }
    }

    protected void validateIfApplicable(WebDataBinder binder, MethodParameter methodParam) {
        Class<?> targetClass = binder.getTarget().getClass();
        super.validateIfApplicable(binder, methodParam);
        Validated validatedAnn = (Validated)methodParam.getParameterAnnotation(Validated.class);
        if (validatedAnn == null) {
            return;
        }
        if (methodParam instanceof ContextualizedMethodParameter) {
            DeserializationHints hints = ((ContextualizedMethodParameter)methodParam).getHints();
            for (Validator validator : binder.getValidators()) {
                if (!HintedValidator.class.isAssignableFrom(validator.getClass()) || !validator.supports(targetClass)) continue;
                ((HintedValidator)validator).validateWithHints(binder.getTarget(), (Errors)binder.getBindingResult(), hints);
            }
        }
    }
}

