/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import javax.persistence.EntityNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.JsonException;

@ControllerAdvice(assignableTypes={BaseRestController.class})
public class RestApiExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestApiExceptionHandler.class);

    @ExceptionHandler(value={RuntimeException.class})
    ResponseEntity<?> catchAll(Exception ex) {
        LOGGER.error("wrapped-exception handler invoked, attempting to resolve the root exception");
        return this.dispatch(ex);
    }

    @ExceptionHandler
    ResponseEntity<?> handleNotFound(EntityNotFoundException ex) {
        LOGGER.error(ex.getMessage(), (Throwable)ex);
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new JsonException((Exception)ex));
    }

    @ExceptionHandler
    ResponseEntity<?> handleAccessDenied(AccessDeniedException ex) {
        LOGGER.error(ex.getMessage(), (Throwable)ex);
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)new JsonException((Exception)ex));
    }

    private ResponseEntity<?> handleAnyException(Exception ex) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("resolving exception '" + ex.getClass().getName() + "' with the catch-all handler", (Throwable)ex);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new JsonException(ex));
    }

    private ResponseEntity<?> dispatch(Exception unqualifiedException) {
        Throwable root = this.findRootException(unqualifiedException);
        if (EntityNotFoundException.class.isAssignableFrom(root.getClass())) {
            return this.handleNotFound((EntityNotFoundException)root);
        }
        return this.handleAnyException((Exception)root);
    }

    private Throwable findRootException(Exception caught) {
        Throwable root = caught;
        while (root.getCause() != null && root.getCause() != root) {
            root = root.getCause();
        }
        return root;
    }
}

