/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.RelProvider;
import org.springframework.util.StringUtils;
import org.squashtest.tm.plugin.rest.core.jackson.RestDtoName;

public class RestApiRelProvider
implements RelProvider {
    public boolean supports(Class<?> delimiter) {
        return true;
    }

    public String getItemResourceRelFor(Class<?> type) {
        return this.hyphenatedClassname(type);
    }

    public String getCollectionResourceRelFor(Class<?> type) {
        RestDtoName annotation = (RestDtoName)AnnotationUtils.findAnnotation(type, RestDtoName.class);
        if (annotation != null) {
            return String.valueOf(annotation.value()) + "s";
        }
        return String.valueOf(this.hyphenatedClassname(type)) + "s";
    }

    private String hyphenatedClassname(Class<?> type) {
        return StringUtils.uncapitalize((String)type.getSimpleName()).replaceAll("(?=[A-Z])", "-$0").toLowerCase();
    }
}

