/*
 *     This file is part of the Jira Agile synchronization connector for Squash TM (plugin.requirement.xsquash4jira) project.
 *     Copyright (C) 2017 - 2019 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
require(['common'], function () {

    require(["jquery", "app/pubsub", "app/ws/squashtm.notification", "underscore", "squash.configmanager",
            "squash.basicwidgets", "squash.translator", "app/util/PathUtils", "./jirasync/jirasync-create-sync-dialog",
            "app/ws/squashtm.workspace", "jquery.squash.togglepanel", "squashtable", "jquery.squash.formdialog", "jquery.switchButton"],
        function ($, pubsub, notification, _, confman, basic, translator, pathUtils, CreateSyncDialog) {

            // *********** Prefiling the ajax with the required token (Squash 1.18+) ***********

            if ($("meta[name='_csrf']").length > 0) {
                $.ajaxPrefilter(function (options, originalOptions, jqXHR) {
                    var token = $("meta[name='_csrf']").attr("content");
                    var header = $("meta[name='_csrf_header']").attr("content");
                    jqXHR.setRequestHeader(header, token);
                });
            }


            // ********* events subscription *********************
            pubsub.subscribe("jirasync.configuration.filtertable", configureSyncTable);
            pubsub.subscribe("jirasync.configuration.jirafields", configureJiraFields);
            pubsub.subscribe("jirasync.configuration.mappingtable", configureMappingTable);
            pubsub.subscribe("jirasync.configuration.valuemappings", configureValuesMapping);
            pubsub.subscribe("jirasync.configuration.dialogs", configurePopups);
            pubsub.subscribe("jirasync.configuration.complete", complete);
            pubsub.subscribe("jirasync.configuration.linktable", configureLinkTable);


            // ********* filter table configuration ***********

            function configureSyncTable() {

                var table = $("#jirasync-sync-table");
                var configuration = squashtm.plugin.jirasync.conf.synchronisations;

                // validation function
                function onsubmit(settings, editable) {
                    //validation must be done server side, and show to user with error dialog
                    return true;
                }

                function oncomplete(value, settings) {
                    var td = this;
                    var row = td.parentNode;
                    var field = getfield(td);
                    var data = table.fnGetData(row).not('.jirasync-enable');
                    data[field] = value;

                    table.fnUpdate(data, row);
                }

                function noNavigation(evt){
                    evt.preventDefault();
                }
                var postFunction = makePostfunction(baseUrl() + '/sync', table);

                function configureStyle($row, data){
                    var cells = $row.find('>td').not('.jirasync-id, jirasync-enabled, .btnDelete'),
                        state = data['synchronisationEnable'];

                    if (state){
                        cells.removeClass('disabled-transparent');
                        cells.off('click', noNavigation);

                    }
                    else{
                        cells.addClass('disabled-transparent');
                        cells.on('click', noNavigation);

                    }
                }

                function configureEditable(){

                    var rows = table.fnGetNodes();
                    rows.forEach(function (row) {
                        var $row = $(row),
                            cells =$row.find('td.jirasync-name, .jirasync-selectValue'),
                            data = table.fnGetData(row),
                            selectType = data.selectTypeConst;
                        if(data.synchronisationEnable) {
                            if (selectType === "BOARD") {
                                cells = $('td:eq(7),td:eq(3),td:eq(6)', $row);
                            }
                            var edconf = confman.getStdJeditable();
                            // validation callback
                            edconf.onsubmit = onsubmit;

                            // table update callback
                            edconf.callback = oncomplete;
                            cells.editable(postFunction, edconf);
                        }
                    })
                }


                table.squashTable({
                        bServerSide: false,
                        aaData: configuration,

                        fnDrawCallback: function () {

                            configureEditable();

                        },

                        // here we draw the editable on sync of type BOARD only
                        fnRowCallback: function (nRow, aData, iDisplayIndex) {

                            var $row = $(nRow);
                            var switchcell = $row.find('.jirasync-enable');
                            var isActive =  $row.find('#isActive').prop('checked') !== undefined ?  $row.find('#isActive').prop('checked').toString() : switchcell.text();

                            var chk = $("<input >", {
                                'type': 'checkbox',
                                'id': 'isActive'
                            });
                            switchcell.empty().append(chk);

                            chk.switchButton({
                                on_label: null,
                                off_label:  null,
                                checked: isActive==="true"

                            });

                        configureStyle($row, aData)

                            $row.find('#isActive').on("change",function (onChange) {

                                var syncId = aData['id'];
                                var data = !aData['synchronisationEnable'];

                            $.ajax({
                                url:  baseUrl()+'/sync/'+ syncId + '/changeSynchronisationId',
                                type:'POST',
                                data : {synchronisationEnable:data}

                            }).success(function (){
                                aData['synchronisationEnable'] = !aData['synchronisationEnable'];
                                configureStyle($row, aData);
                                configureEditable();

                            })
                        })

                        }
                    },

                    {
                        buttons: [
                            {
                                tdSelector: "td.jirasync-force-resync",
                                uiIcon: "ui-icon-circle-arrow-s",
                                jquery: true,
                                onClick: function (table, cell) {
                                    var row = cell.parentNode.parentNode;
                                    var data = table.fnGetData(row);
                                    var dialog = $("#jirasync-force-sync-dialog");
                                    if (data.synchronisationEnable == true) {
                                        dialog.data("syncId", data.id);
                                        dialog.formDialog('open');
                                    }
                                }
                            }

                        ],
                        functions: {


                            validate: function (sync) {
                                var path = sync.synchronisationPath;
                                if (!pathUtils.validatePartialPath(path)) {
                                    return "path-error";
                                }

                                // else, no error
                                return "no-error";
                            },

                            deleteRowsByIds: function (ids) {
                                var self = this;
                                var rows = self.getRowsByIds(ids);
                                rows.each(function () {
                                    self.fnDeleteRow(this, null, false);
                                });
                                self.fnDraw();
                            }
                        }
                    });
            }

            // ********* jira fields configuration ***********
            function configureJiraFields() {

                function makeJiraFieldEditable(jiraFieldId) {

                    function makePostFunctionForJiraField(jiraFieldId) {
                        return function (value, setting) {

                            var url = baseUrl() + '/' + jiraFieldId;

                            $.ajax({
                                url: url,
                                type: 'POST',
                                data: {value: value}
                            });

                            return value;
                        }
                    }


                    var editableConfiguration = confman.getStdJeditable(),
                        postFunction = makePostFunctionForJiraField(jiraFieldId),
                        editableField = $("#" + jiraFieldId);

                    editableField.editable(postFunction, editableConfiguration);

                }

                makeJiraFieldEditable("jira-field-test-status");
                makeJiraFieldEditable("jira-field-progress-redaction");
                makeJiraFieldEditable("jira-field-progress-verification");
                makeJiraFieldEditable("jira-field-progress-validation");
                makeJiraFieldEditable("jira-field-redaction-ratio");
                makeJiraFieldEditable("jira-field-verification-ratio");
                makeJiraFieldEditable("jira-field-validation-ratio");

            }


            // ********* filter table configuration ***********

            function configureMappingTable() {

                var globconf = squashtm.plugin.jirasync.conf,
                    configuration = globconf.configuration,
                    table = $("#jirasync-mappings-table"),
                    allFields = globconf.availableFields;

                var postfunction = makePostfunction(baseUrl() + '/mappings', table);

                // this function creates the list of available items in the dropdown menu
                // note that in the context of an (optional) given row, the ID of that row will still be included in the dropdown
                var mkFieldlist = function (ctxt) {
                    var allids = table.squashTable().fnGetData().map(function (data) {
                        return data.id
                    });

                    var effective = _.omit(allFields, allids);

                    // Special case : if a context is supplied (a table row), add back the key-value it represents
                    // and make it the default for it
                    if (ctxt !== undefined) {
                        rId = table.fnGetData(ctxt).id;
                        effective[rId] = allFields[rId];
                        effective.selected = rId;
                    }

                    return effective;
                };

                function squashFieldCallback(value, settings) {
                    var td = this;
                    var row = td.parentNode;
                    var data = table.fnGetData(row);

                    data.squashField = value;
                    data.id = data.squashField;

                    table.fnUpdate(data, row);
                    table.fnDraw();	// this will reinitialize the content of jeditables
                };

                table.squashTable({
                    bServerSide: false,
                    aaData: configuration.fieldMappings,
                    fnDrawCallback: function () {

                        var self = this;

                        var rows = table.fnGetNodes();
                        rows.forEach(function (row) {
                            var $row = $(row),
                                sqcell = $row.find('td.jirasync-squashfield'),
                                jcell = $row.find('td.jirasync-jirafield');

                            sqcell.text(allFields[sqcell.text()]);

                            // now the features for the editable rows
                            var locked = table.fnGetData(row).locked;
                            if (!locked) {
                                // configure the dropdown for the squash field
                                var sconf = confman.getJeditableSelect();
                                sconf.data = mkFieldlist(row);
                                sconf.callback = squashFieldCallback;
                                sqcell.editable(postfunction, sconf);

                                // configure the text editable for jira field
                                var jconf = confman.getStdJeditable();
                                jcell.editable(postfunction, jconf);
                            }
                        });
                    }
                }, {
                    // because not all rows can be deleted
                    // we must configure a custom handling of deletion
                    buttons: [{
                        tdSelector: 'td.delete-mapping-button',
                        uiIcon: function (row, data) {
                            return (data.locked) ? 'ui-icon-locked' : 'ui-icon-minus';
                        },
                        disabled: function (row, data) {
                            return data.locked;
                        },
                        jquery: true,
                        onClick: function (table, cell) {
                            var row = $(cell).parents('tr').get(0);
                            var id = table.getODataId(row);
                            var popup = $("#jirasync-mappings-delete-dialog");
                            popup.data('entity-id', id);
                            popup.formDialog('open');
                        }
                    }],

                    functions: {
                        // because the native function doesn't allow non-numeric ids, we have to override it
                        getODataId: function (arg) {
                            return this.fnGetData(arg)['id'];
                        },

                        deleteRowsByIds: function (ids) {
                            var self = this;
                            var rows = self.getRowsByIds(ids);
                            rows.each(function () {
                                if (!self.fnGetData(this).locked) {
                                    self.fnDeleteRow(this, null, false);
                                }
                            });
                           self.fnDraw();
                           // location.reload();
                        }
                    }
                });

                // bind the '+' button
                $("#jirasync-mappings-add-button").on('click', function () {
                    var available = mkFieldlist();
                    if (_.isEmpty(available)) {
                        notification.showWarning(translator.get('henix.jirasync.configuration.mappings.allaremapped'));
                    } else {
                        var firstAvailable = _.keys(available)[0];
                        var mapping = {
                            id: firstAvailable,
                            squashField: firstAvailable,
                            jiraField: "",
                            locked: false
                        };

                        $.ajax({
                            url: baseUrl() + '/mappings',
                            type: 'POST',
                            contentType: 'application/json',
                            data: JSON.stringify(mapping)
                        })
                            .success(function () {
                                table.squashTable().fnAddData(mapping);
                            });


                    }
                });

            }

            // ********* custom value mapping configuration *********

            function configureValuesMapping() {
                var saveBtn = $("#jirasync-value-mappings-save"),
                    restoreBtn = $("#jirasync-value-mappings-restore"),
                    textarea = $("#jirasync-value-mappings-text");
                /*,
                                            reminder = $("#jirasync-value-mappings-reminder");*/


                /*
                 * Logic binding the textarea, the save and restore button :
                 * - restore btn starts its lifecycle disabled.
                 * - on textarea content chage - > restore button is enabled
                 * - on successful save or successful restore -> restore button is disabled
                 */


                // enable TAB in the text area,
                // trigger save on ENTER,
                // activate the restore button on first change
                // same for save reminder message
                // credits goes to http://jsfiddle.net/2wAzx/13/
                textarea.on('keydown', function (evt) {

                    //activate the restore button
                    restoreBtn.removeClass('not-displayed');
                    saveBtn.removeClass("not-displayed");

                    var key = evt.keyCode || evt.which;

                    // 9 is TAB
                    if (key === 9) {
                        // get caret position/selection
                        var val = this.value,
                            start = this.selectionStart,
                            end = this.selectionEnd;

                        // set textarea value to: text before caret + spaces + text after caret
                        // note : 'tab' ('\t') is not a valid yaml character so we will insert tree spaces instead
                        this.value = val.substring(0, start) + '   ' + val.substring(end);

                        // put caret at right position again
                        this.selectionStart = this.selectionEnd = start + 3;

                        // prevent the focus lose
                        return false;
                    }

                });

                // save action
                saveBtn.on('click', function () {
                    var txt = textarea.val();
                    $.ajax({
                        url: baseUrl() + '/valuemappings',
                        type: 'POST',
                        data: {value: txt}
                    })
                        .success(function () {
                            saveBtn.addClass('not-displayed');
                            restoreBtn.addClass('not-displayed');
                        });
                });

                //restore action
                restoreBtn.on('click', function () {
                    $.get(baseUrl() + '/valuemappings')
                        .success(function (yaml) {
                            textarea.val(yaml);
                            saveBtn.addClass('not-displayed');
                            restoreBtn.addClass('not-displayed');
                        });
                });


            }

            // ********* requirements links table configuration *********

            function configureLinkTable() {

                var globconf = squashtm.plugin.jirasync.conf,
                    configuration = globconf.configuration,
                    table = $("#jirasync-links-table"),
                    allLinksTypes = globconf.linkTypes;

                var postfunction = makePostfunction(baseUrl() + '/links', table);

                table.squashTable({
                    bServerSide: false,
                    aaData: configuration.fieldLinks,
                    fnDrawCallback: function () {

                        var rows = table.fnGetNodes();
                        rows.forEach(function (row) {
                            var $row = $(row),
                                sqcell = $row.find('td.jirasync-squashfield'),
                                jcell = $row.find('td.jirasync-jirafield');

                            var data = table.fnGetData(row);

                            data.id = data.squashField;
                            sqcell.text(allLinksTypes[sqcell.text()]);

                            // configure the text editable for jira field
                            var jconf = confman.getStdJeditable();
                            jcell.editable(postfunction, jconf);
                        });
                    }
                }, {
                    functions: {
                        // because the native function doesn't allow non-numeric ids, we have to override it
                        getODataId: function (arg) {
                            return this.fnGetData(arg)['id'];
                        }
                    }
                });
            }

            // ********* popups configuration ***********

            function configurePopups() {
                var globconf = squashtm.plugin.jirasync.conf.configuration;
                configureAddSyncDialog(globconf);
                configureRemoveSyncDialog(globconf);
                configureRemoveMappingDialog(globconf);
                makeForceSyncDialog(globconf);
            }

            function configureAddSyncDialog(globconf) {

                var table = $("#jirasync-sync-table");

                var dialog = $("#add-sync-dialog");
                dialog.formDialog({"minWidth": 800});

                function clean() {
                    dialog.find("#jirasync-add-sync-name").val("");
                    dialog.find("#jirasync-add-sync-path").val("");
                    dialog.find("#jirasync-add-sync-server").val("0");
                    dialog.find("#jirasync-add-sync-select-type").val("BOARD");
                    dialog.find("#jirasync-add-sync-select-value").val("");
                    dialog.find("#jirasync-add-sync-additional-jql").val("");
                    dialog.find("#jirasync-add-sync-restrain-to-active-sprint").prop("checked", false);
                    showSelectValueLabelForBoard();
                    showBoardOptions();
                }

                function showBoardOptions() {
                    //show option for board
                    dialog.find(".jirasync-board-option").show();
                }

                function hideBoardOptions() {
                    //show option for board
                    dialog.find(".jirasync-board-option").hide();
                }

                function showSelectValueLabelForBoard() {
                    dialog.find("#jirasync-add-sync-select-value-board-label").show();
                    dialog.find("#jirasync-add-sync-select-value-jql-label").hide();
                    dialog.find("#jirasync-add-sync-select-value-filter-label").hide();
                }

                function showSelectValueLabelForFilter() {
                    dialog.find("#jirasync-add-sync-select-value-board-label").hide();
                    dialog.find("#jirasync-add-sync-select-value-jql-label").hide();
                    dialog.find("#jirasync-add-sync-select-value-filter-label").show();
                }

                function showSelectValueLabelForJQL() {
                    dialog.find("#jirasync-add-sync-select-value-board-label").hide();
                    dialog.find("#jirasync-add-sync-select-value-jql-label").show();
                    dialog.find("#jirasync-add-sync-select-value-filter-label").hide();
                }
                function initChangeTypeCheckbox() {
                    var selectTypeBox = dialog.find("#jirasync-add-sync-select-type");
                    selectTypeBox.change(function () {
                        var selectType = selectTypeBox.val();
                        if (selectType === "BOARD") {
                            showSelectValueLabelForBoard();
                            showBoardOptions();
                        } else if (selectType === "QUERY") {
                            showSelectValueLabelForJQL();
                            hideBoardOptions();
                        } else if (selectType === "FILTER") {
                            showSelectValueLabelForFilter();
                            hideBoardOptions();
                        } else {
                            throw "Unknown select type for jira Sync : " + selectType;
                        }
                    });
                }

                initChangeTypeCheckbox();

                // open, cleanup
                dialog.on('formdialogopen', function () {
                    clean();
                });

                // confirmation
                dialog.on('formdialogconfirm', function () {


                    var sync = {
                        name: $.trim($("#jirasync-add-sync-name").val()),
                        serverId: $.trim($("#jirasync-add-sync-server").val()),
                        synchronisationPath: $.trim($("#jirasync-add-sync-path").val()),
                        selectType: $.trim($("#jirasync-add-sync-select-type").val()),
                        selectValue: $.trim($("#jirasync-add-sync-select-value").val()),
                        additionalJQL: $.trim($("#jirasync-add-sync-additional-jql").val()),
                        restrainToActiveSprint: $("#jirasync-add-sync-restrain-to-active-sprint").prop("checked"),

                    };

                    var error = table.squashTable().validate(sync);

                    if (error === "no-error") {
                        $.ajax({
                            url: baseUrl() + '/sync',
                            type: 'POST',
                            data: JSON.stringify(sync),
                            contentType: 'application/json'
                        })
                            .success(function (response) {
                                dialog.formDialog('close');
                                table.squashTable().fnAddData(response);
                                //location.reload();
                            });
                    } else if (error === "path-error") {
                        notification.showWarning(translator.get('henix.jirasync.filters.dialog.add.pathinvalid'));
                    } else {
                        dialog.find('.jirasync-invalid-' + error).show();
                    }
                });

                // rejection
                dialog.on('formdialogcancel', function () {
                    dialog.formDialog('close');
                });

                // opening
                $("#jirasync-filters-add-button").on('click', function () {
                    dialog.formDialog('open');
                });
                return dialog;
            }


            function configureRemoveSyncDialog(globconf) {

                var table = $("#jirasync-sync-table");
                var dialog = $("#jirasync-filters-delete-dialog");

                dialog.formDialog();

                dialog.on('formdialogcancel', function () {
                    dialog.formDialog('close');
                });

                var deleteconfirm = makeConfirmDelete(table, dialog, baseUrl() + '/sync');
                dialog.on('formdialogconfirm', deleteconfirm);

                $("#jirasync-filters-delete-button").on('click', function () {
                    var select = table.squashTable().getSelectedIds();
                    if (select.length === 0) {
                        notification.showWarning(translator.get('message.EmptyTableSelection'));
                    } else {
                        dialog.formDialog('open');
                    }
                });


                return dialog;
            }


            function configureRemoveMappingDialog(globconf) {

                var table = $("#jirasync-mappings-table");
                var dialog = $("#jirasync-mappings-delete-dialog");

                dialog.formDialog();

                dialog.on('formdialogcancel', function () {
                    dialog.formDialog('close');
                });

                var deleteconfirm = makeConfirmDelete(table, dialog, baseUrl() + '/mappings');
                dialog.on('formdialogconfirm', deleteconfirm);

                $("#jirasync-mappings-delete-button").on('click', function () {
                    var select = table.squashTable().getSelectedIds();
                    if (select.length === 0) {
                        notification.showWarning(translator.get('message.EmptyTableSelection'));
                    } else {
                        dialog.formDialog('open');
                    }
                });


                return dialog;
            }

            function makeForceSyncDialog(globconf) {
                var dialog = $("#jirasync-force-sync-dialog");

                dialog.formDialog();

                dialog.on('formdialogcancel', function () {
                    dialog.formDialog('close');
                });


                dialog.on('formdialogconfirm', function () {
                    //we return a new function each time formdialogconfirm is called, so the syncId is correctly updated at call time
                    return function () {
                        var syncId = dialog.data("syncId");
                        var url = baseUrl() + "/sync" + "/" + syncId + "/full";

                        $.ajax({
                            url: url,
                            type: 'PUT',
                            data: {}
                        }).success(function () {
                            dialog.formDialog('close');
                        });
                    }
                }());
            }


            // ********* final initialization ***********

            function complete() {
                basic.init();
            }


            // ******** common code *********************


            function baseUrl() {
                var globconf = squashtm.plugin.jirasync.conf;
                return squashtm.app.contextRoot + 'jirasync/project/' + globconf.projectId + '/configuration';
            }


            // looks for 'key' in css class jirasync-key, 'filter' in 'jirasync-filter' etc
            function getfield(td) {
                var classes = td.className;
                return /jirasync-(\w+)/.exec(classes)[1];
            }

            function makePostfunction(baseurl, table) {
                return function (value, settings) {
                    var td = this;

                    var row = td.parentNode;
                    var field = getfield(td);
                    var rowmodel = table.fnGetData(row);

                    var url = baseurl + '/' + rowmodel.id + '/' + field;

                    $.ajax({
                        url: url,
                        type: 'POST',
                        data: {value: value}
                    });

                    return value;
                }
            }

            function makeConfirmDelete(table, dialog, baseurl) {
                return function () {
                    var ids;
                    var id = dialog.data('entity-id');
                    if (!!id) {
                        ids = [id];
                    } else {
                        ids = table.squashTable().getSelectedIds();
                    }

                    $.ajax({
                        url: baseurl + '/' + ids.join(','),
                        type: 'DELETE'
                    })
                        .success(function () {
                            dialog.removeData('entity-id');
                            dialog.formDialog('close');
                            table.squashTable().deleteRowsByIds(ids);
                        });
                }
            }
        })
});
