/*
 *     This file is part of the Jira Agile synchronization connector for Squash TM (plugin.requirement.xsquash4jira) project.
 *     Copyright (C) 2017 - 2019 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define(["./BaseModel", "./BaseScreen"], function(BaseModel, BaseScreen){

	
	// ************* Action model ***************** 
	
	var ActionModel = BaseModel.extend({
	
		defaults : {
			action : "UPDATE_CPG"
		},
		
		produces : ['action'],
		
		
		init : function(mega){
			var action = mega.selectedNode().type === 'iteration' ? "UPDATE_IT" : "UPDATE_CPG";
			return {
				action : action
			};
		}
		
	});
	
	
	// *********** Action Screen **************
	
	var ActionScreen = BaseScreen.extend({
		
		name : "action",
		
		el : "#screen-action",
		
		template : "#jirsync-plan-action-template",

		templateModel : function(){
			return {
				radiocheck : this.model.action()
			};
		},
		
		events : {
			'change input[type="radio"]' : "setAction"
		},
		
		setAction : function(evt){
			var value = $(evt.currentTarget).val();
			this.model.action(value);
		}
	});	
	
	
	return {
		model : ActionModel,
		screen : ActionScreen
	};
	
});
