/*
 *     This file is part of the Jira Agile synchronization connector for Squash TM (plugin.requirement.xsquash4jira) project.
 *     Copyright (C) 2017 - 2019 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define(["./BaseModel", "./BaseScreen", "underscore", "app/util/StringUtil"], function(BaseModel, BaseScreen, _, StringUtils){
	
	var serviceUrl = squashtm.app.contextRoot + 'jirasync/servers';
	
	var JQLModel = BaseModel.extend({
		
		produces : ["jql"],
		
		defaults :{
		
			// ---- the output of that screen -----
			jql : {
				serverId : -1,
				expression : ""
			},
		
			// ---- UI state -----
			servers : []
		},
		
		hasServers : false,
		
		fetchServersIfNeeded : function(){
			
			if (this.hasServers){
				return $.Deferred().resolve().promise();
			}
			
			var self = this;
			var url = serviceUrl;
			
			return $.getJSON(url).done(function(jsonServers){
				self.servers(jsonServers);
				// also initialize the model
				self.jql({
					serverId : jsonServers[0].id,
					expression : ""
				});
				self.hasServers = true;
				return this;
			});
			
		}
		
	});
	
	
	
	
	var JQLScreen = BaseScreen.extend({
		
		 name : "jql",
		 
		 template : "#jirsync-plan-bysprint-jql-template",
		 
		 el : "#screen-jql",
		 
		 templateModel : function(){
			 var servers = this.model.servers();
			 var jql = this.model.jql();
			 var selected = _.findWhere(servers, {id : jql.serverId});
			
			 return {
				 servers : servers,
				 jql : jql,
				 selected : selected
			 }
		 },
		 
		 render : function(){
			 var self = this;
			 
			this.__renderWait();
			this.model.fetchServersIfNeeded()
				.done(function(){
					BaseScreen.prototype.__renderValid.apply(self, arguments);
				});
			
			return this;
		 },
		 
		 events : {
			 'change select' : 'updateJql',
			 'change textarea' : 'updateJql'
		 },
		 
		 updateJql : function(){
			 var serverId = this.$el.find('select').val();
			 serverId = parseInt(serverId, 10);
			 var expression = this.$el.find('textarea').val();
			 
			 var jql = this.model.jql();
			 jql.serverId = serverId;
			 jql.expression = expression;
			 this.model.jql(jql);
			 //[Issue 7900] Render to change server url value displayed
			 this.render();
			 // force event trigger because Backbone won't do it 
			 // we just give it the same jql object after all
			 this.model.mega.trigger('change:jql');
		 },
		 
		 // **** screen status determination *** 
		 
		 // isReady : doesn't need override (its always true)
		 
		 isComplete : function(){
			var content = this.model.jql();
			return (content.serverId !== undefined && ! StringUtils.isBlank(content.expression));
		 }
		 
		 
	});
	
	
	
	return {
		model : JQLModel,
		screen : JQLScreen
	};
	
	
});