/*
 *     This file is part of the Jira Agile synchronization connector for Squash TM (plugin.requirement.xsquash4jira) project.
 *     Copyright (C) 2017 - 2019 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
/* 
 * MegaModel
 * 
 * 
 * The MegaModel is a particular  model shared by everyone, either as a direct dependency
 * or through a screen model that delegate to it.
 * 
 * This is probably the only model that ever receives attributes
 * as initialization. All other models salvage properties from, 
 *  and/or delegate properties to it.		
 *
 * Its defaults hash defines pretty much a list of every shared, important 
 * properties.
 * 
 * Because this model is THE megamodel, all these properties
 * will be automatically delegated by any other BaseModel 
 * that receives this as an option. See the documentation 
 * of BaseModel for details.
 *
 */ 
define(["./BaseModel", './IterationFormModel'], function(BaseModel, IterationFormModel){
	

	var MegaModel = BaseModel.extend({
		
		/*
		 * This is pretty much a list of every shared, important 
		 * properties.
		 * 
		 * Because this model is THE megamodel, all these properties
		 * will be automatically delegated by any other BaseModel 
		 * that receives this as an option. See the documentation 
		 * of BaseModel for details.
		 */
		defaults : {
			selectedNode : null,
			action : "UPDATE_CPG",
			strategy : "BY_RELEASE",
			
			iteration : new IterationFormModel(),

			selectedTickets : [],
			selectedTestCases : [],
			
			// BY_RELEASE attributes
			selectedReleases : [],
			
			// BY_SPRINT attributes
			selectedSprints : [],
	
			//BY_JQL attributes
			//corresponds to org.squashtest.tm.plugin.jirasync.domain.execplan.JqlSearch
			jql : {
				serverId : -1,
				expression : ""
			}
		},
		
		initialize : function(attributes, options){
			var defaultAction = (attributes.selectedNode.type === "iteration") ? "UPDATE_IT" : "UPDATE_CPG";
			attributes.action = defaultAction;
			this.action(defaultAction);
			BaseModel.prototype.initialize.apply(this, arguments);
		},
		
		findNested : function(complexAttr){
			var traversal = complexAttr.split('.');
			
			var attrValue = this.attributes;
			
			while(traversal.length > 0){
				var attr = traversal.shift();
				attrValue = attrValue[attr];
			}
			
			return attrValue;
			
		}
		
		
	});
	
	return MegaModel;
	
});