/*
 *     This file is part of the Jira Agile synchronization connector for Squash TM (plugin.requirement.xsquash4jira) project.
 *     Copyright (C) 2017 - 2019 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define([], function(){
	
	
	class EntityReference{
		constructor(restype, resid){
			this.type = restype;
			this.id = resid;
		}
	}
	
	class Release{
		constructor(id, name, releaseDate){
			this.id = id;
			this.name = name;
			this.releaseDate = releaseDate;
		}
	}
	
	class ProjectReleases{
		constructor(project, releases){
			this.project = project;
			this.releases = releases;
		}
	}
	

	// turns an array of ProjectRelease to a flattened array of <projectname>-<releaseid>
	ProjectReleases.toStrings = function(projectReleases){
		return _.chain(projectReleases)
		.map(function(projrel){
			var projname = projrel.project;
			return projrel.releases.map(function(release){return projname+"-"+release.id  });
		})
		.flatten()
		.value();
	};

	// this is the reverse operation of toStrings
	ProjectReleases.fromStrings = function(stringFormatted){
		
		// this is a map of <string, list<long>> in javaspeak
		var hashmap = {};
		
		stringFormatted.forEach(function(str){
			var split = str.split('-');
			var proj = split[0],
				relId = split[1];
			
			hashmap[proj] = hashmap[proj] || [];
			hashmap[proj].push({ id : relId});
		});
		
		// now convert as project release
		var releases = Object.keys(hashmap).map(function(entry){
			var project = entry;
			var releases = hashmap[entry];
			return new ProjectReleases(project, releases);
		});	
		
		return releases;
	};
	
	class Sprint{
		constructor(id, state, name, completeDate){
			this.id = id;
			this.state = state;
			this.name = name;
			this.completeDate = completeDate;
		}
	}
	
	class BoardSprints{
		constructor(board, sprints){
			this.board = board;
			this.sprints = sprints;
		}
	}
	
	// ******************* helper functions ****************
	
	// turns an array of ProjectRelease to a flattened array of <projectname>-<releaseid>
	ProjectReleases.toStrings = function(projectReleases){
		return _.chain(projectReleases)
		.map(function(projrel){
			var projname = projrel.project;
			return projrel.releases.map(function(release){return projname+"-"+release.id  });
		})
		.flatten()
		.value();
	};

	// this is the reverse operation of toStrings
	ProjectReleases.fromStrings = function(stringFormatted){
		
		// this is a map of <string, list<long>> in javaspeak
		var hashmap = {};
		
		stringFormatted.forEach(function(str){
			var split = str.split('-');
			var proj = split[0],
				relId = split[1];
			
			hashmap[proj] = hashmap[proj] || [];
			hashmap[proj].push({ id : relId});
		});
		
		// now convert as project release
		var releases = Object.keys(hashmap).map(function(entry){
			var project = entry;
			var releases = hashmap[entry];
			return new ProjectReleases(project, releases);
		});	
		
		return releases;
	};
	
	
	// now the same functions for BoardSprints
	
	BoardSprints.toStrings = function(boardSprints){
		return _.chain(boardSprints)
		.map(function(boardsprint){
			var boardname = boardsprint.board;
			return boardsprint.sprints.map(function(sprint){return boardname+"-"+sprint.id  });
		})
		.flatten()
		.value();
	};

	BoardSprints.fromStrings = function(stringFormatted){
		
		// this is a map of <string, list<long>> in javaspeak
		var hashmap = {};
		
		stringFormatted.forEach(function(str){
			var split = str.split('-');
			var board = split[0],
				sprId = split[1];
			
			hashmap[board] = hashmap[board] || [];
			hashmap[board].push({ id : sprId});
		});
		
		// now convert as project release
		var boardsprints = Object.keys(hashmap).map(function(entry){
			var board = entry;
			var sprints = hashmap[entry];
			return new BoardSprints(board, sprints);
		});	
		
		return boardsprints;
	};	
	
	// ****************** the module ***********************
	
	return {
		EntityReference 	: EntityReference,
		Release 			: Release,
		ProjectReleases 	: ProjectReleases,
		Sprint 				: Sprint,
		BoardSprints		: BoardSprints
	}
	
});