/*
 *     This file is part of the Jira Agile synchronization connector for Squash TM (plugin.requirement.xsquash4jira) project.
 *     Copyright (C) 2017 - 2019 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
/*
 * That module extracts message from json errors only
 */
define([], function(){
	
	
	return {
		
		extractMessage : function(json){
			// /1
			// is that an exception wrapped in a ModelAndView ? 
			// That furthermore wraps a rest call exception, ie is that returned by 
			// ExecplanSynchronizationController#handleRestExceptions ?
			if (json['jira-exception'] !== undefined){
				// if so return the first error message encountered
				return json['jira-exception'].errorCollections[0].errorMessages[0];
			}
			// 2/ maybe it's a raw exception ? 
			else{
				// just return the message
				return json.message;
			}
			
		}
		
	}
	
	
});