/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.dto;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component(value="report.books.requirements.i18nHelper")
public class I18nHelper
implements MessageSourceAware {
    private static MessageSource msgSource;

    private static Locale currentLocale() {
        Locale current = LocaleContextHolder.getLocale();
        if (current == null) {
            current = Locale.getDefault();
        }
        return current;
    }

    public static String translate(String string) {
        return msgSource.getMessage(string, null, I18nHelper.currentLocale());
    }

    public static String translate(String string, Object[] params) {
        return msgSource.getMessage(string, params, I18nHelper.currentLocale());
    }

    public static String translate(Date date) {
        String dateFormat = msgSource.getMessage("squashtm.dateformat", null, I18nHelper.currentLocale());
        return new SimpleDateFormat(dateFormat).format(date);
    }

    public void setMessageSource(MessageSource messageSource) {
        msgSource = messageSource;
    }
}

