/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.squashtest.tm.plugin.report.books.requirements.dto.FolderData;
import org.squashtest.tm.plugin.report.books.requirements.dto.RequirementVersionData;

public class ProjectData {
    private String name;
    private Long id;
    private Collection<FolderData> folders = new TreeSet<FolderData>(new BreadcrumbComparator());

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<RequirementVersionData> getRequirements() {
        ArrayList<RequirementVersionData> requirements = new ArrayList<RequirementVersionData>();
        for (FolderData folder : this.folders) {
            requirements.addAll(folder.getRequirementVersions());
        }
        String lastPath = null;
        for (RequirementVersionData version : requirements) {
            String curPath = version.getPath();
            boolean shouldPrintPath = !curPath.equals(lastPath);
            version.setShouldPrintPath(shouldPrintPath);
            lastPath = curPath;
        }
        return requirements;
    }

    public void setFolders(List<FolderData> folders) {
        this.folders = folders;
    }

    public void addAllFolders(Collection<FolderData> moreFolders) {
        this.folders.addAll(moreFolders);
    }

    public void addFolder(FolderData folder) {
        this.folders.add(folder);
    }

    protected Collection<FolderData> findFolders() {
        return this.folders;
    }

    public boolean acceptsAsContent(FolderData folder) {
        return folder.getProjectId().equals(this.id);
    }

    private class BreadcrumbComparator
    implements Comparator<FolderData> {
        private BreadcrumbComparator() {
        }

        @Override
        public int compare(FolderData folder1, FolderData folder2) {
            int result = this.compareByBeingRoot(folder1, folder2);
            if (result != 0) {
                return result;
            }
            return this.compareBreadcrumbs(folder1, folder2);
        }

        private int compareByBeingRoot(FolderData folder1, FolderData folder2) {
            if (folder1.isPseudoRoot()) {
                return -1;
            }
            if (folder2.isPseudoRoot()) {
                return 1;
            }
            return 0;
        }

        private int compareBreadcrumbs(FolderData folder1, FolderData folder2) {
            String[] crumb1 = folder1.getBreadcrumb().split(" > ");
            String[] crumb2 = folder2.getBreadcrumb().split(" > ");
            int minLength = Math.min(crumb1.length, crumb2.length);
            int i = 0;
            while (i < minLength) {
                int comp = crumb1[i].compareTo(crumb2[i]);
                if (comp != 0) {
                    return comp;
                }
                ++i;
            }
            return crumb1.length < crumb2.length ? -1 : 1;
        }
    }
}

