/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.squashtest.tm.plugin.report.books.requirements.dto.CufData;
import org.squashtest.tm.plugin.report.books.requirements.dto.FolderData;
import org.squashtest.tm.plugin.report.books.requirements.dto.I18nHelper;
import org.squashtest.tm.plugin.report.books.requirements.dto.ReqLinkData;
import org.squashtest.tm.plugin.report.books.requirements.dto.RequirementVersionDataAdapter;
import org.squashtest.tm.plugin.report.books.requirements.dto.TestCaseData;
import org.squashtest.tm.plugin.report.books.requirements.dto.TestCaseProject;

public class RequirementVersionData {
    private Long parentFolderId;
    private Long parentReqVersionId;
    private Long projectId;
    private Long versionId;
    private Long requirementId;
    private String reference;
    private int versionNumber;
    private String criticality;
    private String status;
    private String category;
    private String categoryType;
    private int nbAttachments;
    private String name;
    private String milestoneNames;
    private String path = null;
    private String pathDescription;
    private String description;
    private String createdBy;
    private Date createdOn;
    private String modifiedBy;
    private Date modifiedOn;
    private int totalVersionNumber;
    private List<TestCaseData> boundTestCases = new LinkedList<TestCaseData>();
    private Map<String, TestCaseProject> testCaseProjects = new LinkedHashMap<String, TestCaseProject>();
    private List<RequirementVersionDataAdapter> ancestors = new LinkedList<RequirementVersionDataAdapter>();
    private List<RequirementVersionData> childrenRequirements = new LinkedList<RequirementVersionData>();
    private RequirementVersionDataAdapter parentRequirementVersion;
    private FolderData parentFolder;
    private List<CufData> cufs = new ArrayList<CufData>();
    private List<CufData> rtfCufs = new ArrayList<CufData>();
    private List<CufData> numCufs = new ArrayList<CufData>();
    private List<CufData> tagCufs = new ArrayList<CufData>();
    private List<ReqLinkData> reqLinks = new ArrayList<ReqLinkData>();
    private boolean shouldPrintPath = false;
    private boolean hasReqLink = true;

    public List<CufData> getTagCufs() {
        return this.tagCufs;
    }

    public void setTagCufs(List<CufData> tagCufs) {
        this.tagCufs = tagCufs;
    }

    public Long getParentFolderId() {
        return this.parentFolderId;
    }

    public void setParentFolderId(Long parentFolderId) {
        this.parentFolderId = parentFolderId;
    }

    public Long getParentReqVersionId() {
        return this.parentReqVersionId;
    }

    FolderData getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(FolderData parentFolder) {
        this.parentFolder = parentFolder;
    }

    public List<RequirementVersionData> getChildrenRequirements() {
        return this.childrenRequirements;
    }

    public void setChildrenRequirements(List<RequirementVersionData> childrenRequirements) {
        this.childrenRequirements = childrenRequirements;
    }

    public boolean isShouldPrintPath() {
        return this.shouldPrintPath;
    }

    public void setShouldPrintPath(boolean shouldPrintPath) {
        this.shouldPrintPath = shouldPrintPath;
    }

    public RequirementVersionDataAdapter getParentRequirementVersion() {
        return this.parentRequirementVersion;
    }

    public void setTestCaseProjects(Map<String, TestCaseProject> testCaseProjects) {
        this.testCaseProjects = testCaseProjects;
    }

    public void setAncestors(List<RequirementVersionDataAdapter> ancestors) {
        this.ancestors = ancestors;
    }

    public String getCategoryType() {
        return this.categoryType;
    }

    public void setParentReqVersionId(Long parentReqVersionId) {
        this.parentReqVersionId = parentReqVersionId;
    }

    public void setCategoryType(String categoryType) {
        this.categoryType = categoryType;
    }

    public String getPathDescription() {
        return this.pathDescription;
    }

    public void setPathDescription(String pathDescription) {
        this.pathDescription = pathDescription;
    }

    public String getPath() {
        if (this.path == null) {
            if (this.hasParentRequirementVersion()) {
                String parentPath = this.parentRequirementVersion.getPath();
                String parentName = this.parentRequirementVersion.getName();
                this.path = StringUtils.isBlank((String)parentPath) ? parentName : String.valueOf(parentPath) + " > " + parentName;
            } else {
                this.path = this.getParentFolder().getBreadcrumb();
            }
        }
        return this.path;
    }

    private String translate(String string) {
        return I18nHelper.translate(string);
    }

    public boolean hasParentRequirementVersion() {
        return this.parentReqVersionId != null;
    }

    public List<RequirementVersionDataAdapter> getAncestors() {
        return this.ancestors;
    }

    public void setParentRequirementVersion(RequirementVersionDataAdapter parentRequirementVersion) {
        this.parentRequirementVersion = parentRequirementVersion;
    }

    public void addChildrenRequirement(RequirementVersionData requirement) {
        this.childrenRequirements.add(requirement);
        RequirementVersionDataAdapter parent = new RequirementVersionDataAdapter(this);
        requirement.setParentRequirementVersion(parent);
        requirement.addAncestor(parent);
        requirement.addAncestors(this.ancestors);
    }

    public void addAncestor(RequirementVersionDataAdapter ancestor) {
        this.ancestors.add(ancestor);
    }

    public void addAncestors(List<RequirementVersionDataAdapter> ancestors) {
        this.ancestors.addAll(ancestors);
    }

    public String getParentRequirementDisplayableName() {
        if (this.hasParentRequirementVersion()) {
            RequirementVersionDataAdapter parent = this.parentRequirementVersion;
            return String.valueOf(parent.getName()) + " (ID " + parent.getRequirementId().toString() + ")";
        }
        return "";
    }

    public List<RequirementVersionData> getChildren() {
        return this.childrenRequirements;
    }

    public List<RequirementVersionData> getAllChildren() {
        LinkedList<RequirementVersionData> allChildren = new LinkedList<RequirementVersionData>(this.childrenRequirements);
        for (RequirementVersionData child : this.childrenRequirements) {
            allChildren.addAll(child.getAllChildren());
        }
        return allChildren;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public Long getRequirementId() {
        return this.requirementId;
    }

    public void setRequirementId(Long requirementId) {
        this.requirementId = requirementId;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Integer getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getCriticality() {
        String string = "";
        switch (this.criticality) {
            case "MAJOR": {
                string = "report.books.requirements.criticality.major";
                break;
            }
            case "MINOR": {
                string = "report.books.requirements.criticality.minor";
                break;
            }
            case "CRITICAL": {
                string = "report.books.requirements.criticality.critical";
                break;
            }
            default: {
                string = "report.books.requirements.criticality.undefined";
            }
        }
        return this.translate(string);
    }

    public void setCriticality(String criticality) {
        this.criticality = criticality;
    }

    public String getStatus() {
        String string = "";
        switch (this.status) {
            case "APPROVED": {
                string = "report.books.requirements.status.approved";
                break;
            }
            case "OBSOLETE": {
                string = "report.books.requirements.status.obsolete";
                break;
            }
            case "UNDER_REVIEW": {
                string = "report.books.requirements.status.under_review";
                break;
            }
            case "WORK_IN_PROGRESS": {
                string = "report.books.requirements.status.work_in_progress";
            }
        }
        return this.translate(string);
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCategory() {
        if (this.categoryType.equals("SYS")) {
            return I18nHelper.translate("report.books.requirements." + this.category.toLowerCase());
        }
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public int getNbAttachments() {
        return this.nbAttachments;
    }

    public void setNbAttachments(int nbAttachments) {
        this.nbAttachments = nbAttachments;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedOn() {
        if (this.createdOn != null) {
            return I18nHelper.translate(this.createdOn);
        }
        return "";
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public List<ReqLinkData> getReqLinks() {
        return this.reqLinks;
    }

    public void setReqLinks(List<ReqLinkData> reqLinks) {
        this.reqLinks = reqLinks;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public String getModifiedOn() {
        if (this.modifiedOn != null) {
            return I18nHelper.translate(this.modifiedOn);
        }
        return "";
    }

    public void setModifiedOn(Date modifuedOn) {
        this.modifiedOn = modifuedOn;
    }

    public Collection<TestCaseData> getBoundTestCases() {
        return this.boundTestCases;
    }

    public void setBoundTestCases(List<TestCaseData> boundTestCases) {
        this.boundTestCases = boundTestCases;
    }

    public List<CufData> getCufs() {
        return this.cufs;
    }

    public void setCufs(List<CufData> cufs) {
        this.cufs = cufs;
    }

    public void setRtfCufs(List<CufData> cufs) {
        this.rtfCufs = cufs;
    }

    public List<CufData> getRtfCufs() {
        return this.rtfCufs;
    }

    public List<CufData> getNumCufs() {
        return this.numCufs;
    }

    public void setNumCufs(List<CufData> numCufs) {
        this.numCufs = numCufs;
    }

    public void addAllTestCases(Collection<TestCaseData> data) {
        this.boundTestCases.addAll(data);
    }

    public void addTestCase(TestCaseData data) {
        this.boundTestCases.add(data);
        String projectName = data.getProjectName();
        TestCaseProject project = this.testCaseProjects.get(projectName);
        if (project != null) {
            project.addTestCase(data);
        } else {
            project = new TestCaseProject();
            project.setProjectName(projectName);
            project.addTestCase(data);
            this.testCaseProjects.put(projectName, project);
        }
    }

    public String getMilestoneNames() {
        return this.milestoneNames;
    }

    public void setMilestoneNames(String milestoneLabels) {
        this.milestoneNames = milestoneLabels;
    }

    public int getTotalVersionNumber() {
        return this.totalVersionNumber;
    }

    public void setTotalVersionNumber(int totalVersionNumber) {
        this.totalVersionNumber = totalVersionNumber;
    }

    public boolean hasAttachments() {
        return this.nbAttachments > 0;
    }

    public boolean hasParentFolder() {
        return this.parentFolderId != null;
    }

    public boolean acceptsAsContent(TestCaseData testCase) {
        return testCase.getRequirementVersionId().equals(this.versionId);
    }

    public boolean acceptsAsCuf(CufData cufData) {
        return cufData.getReqVersionId().equals(this.versionId);
    }

    public boolean acceptsAsReqLink(ReqLinkData cufData) {
        return cufData.getReqVersionId().equals(this.versionId);
    }

    public List<TestCaseProject> getTestCaseProjects() {
        return new LinkedList<TestCaseProject>(this.testCaseProjects.values());
    }

    public void sortContent() {
        Collections.sort(this.boundTestCases, new TestCaseSorter());
    }

    public boolean isNoPrintPath() {
        boolean emptyPath = StringUtils.isBlank((String)this.getPath());
        return emptyPath || !this.shouldPrintPath;
    }

    public boolean isHasReqLink() {
        return this.hasReqLink;
    }

    public void setHasReqLink(boolean hasReqLink) {
        this.hasReqLink = hasReqLink;
    }

    public boolean isNoReference() {
        return StringUtils.isBlank((String)this.reference);
    }

    public boolean isUnmodified() {
        return this.modifiedOn == null;
    }

    public boolean isNoCustomField() {
        return this.cufs.size() == 0 && this.rtfCufs.size() == 0 && this.numCufs.size() == 0 && this.tagCufs.size() == 0;
    }

    public boolean isNoBoundTestCase() {
        return this.boundTestCases.size() == 0;
    }

    public boolean isNoBoundRequirement() {
        return this.childrenRequirements.size() == 0 && this.ancestors.size() == 0;
    }

    private class TestCaseSorter
    implements Comparator<TestCaseData> {
        private TestCaseSorter() {
        }

        @Override
        public int compare(TestCaseData tc1, TestCaseData tc2) {
            String name1 = this.normalizeName(tc1);
            String name2 = this.normalizeName(tc2);
            return name1.compareTo(name2);
        }

        private String normalizeName(TestCaseData data) {
            if (StringUtils.isNotBlank((String)data.getReference())) {
                return String.valueOf(data.getReference()) + " - " + data.getName();
            }
            return data.getName();
        }
    }
}

