/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.query;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.squashtest.tm.api.repository.SqlQueryRunner;

public class RequirementTreeQueryFinder {
    private static final String VERSION_IDS = "versionIds";
    private static final String SQL_FIND_MILESTONE_LABEL = "select label from MILESTONE where milestone_id = :milestoneId";
    private String idsByProjectQuery;
    private String lastVersionIdsByProjectQuery;
    private String idsForAllProjectsQuery;
    private String lastVersionIdsForAllProjectsQuery;
    private String idsBySelectionQuery;
    private String lastVersionIdsBySelectionQuery;
    private String idsByMilestoneQuery;
    private String lastVersionIdsByMilestoneQuery;
    private String requirementVersionDataQuery;
    private String folderDataQuery;
    private String projectDataQuery;
    private String boundTCDataQuery;
    private String cufsDataQuery;
    private String rtfCufsDataQuery;
    private String numCufsDataQuery;
    private String tagCufsDataQuery;
    private String idsByTagQuery;
    private String lastVersionIdsByTagQuery;
    private String reqLinkDataQuery;
    protected SqlQueryRunner runner;

    RequirementTreeQueryFinder() {
    }

    void setLastVersionIdsByTagQuery(String lastVersionIdsByTagQuery) {
        this.lastVersionIdsByTagQuery = lastVersionIdsByTagQuery;
    }

    void setLastVersionIdsBySelectionQuery(String lastVersionIdsBySelectionQuery) {
        this.lastVersionIdsBySelectionQuery = lastVersionIdsBySelectionQuery;
    }

    void setLastVersionIdsByMilestoneQuery(String lastVersionIdsByMilestoneQuery) {
        this.lastVersionIdsByMilestoneQuery = lastVersionIdsByMilestoneQuery;
    }

    void setLastVersionIdsByProjectQuery(String lastVersionIdsByProjectQuery) {
        this.lastVersionIdsByProjectQuery = lastVersionIdsByProjectQuery;
    }

    void setLastVersionIdsForAllProjectsQuery(String lastVersionIdsForAllProjectsQuery) {
        this.lastVersionIdsForAllProjectsQuery = lastVersionIdsForAllProjectsQuery;
    }

    void setIdsForAllProjectsQuery(String idsForAllProjectsQuery) {
        this.idsForAllProjectsQuery = idsForAllProjectsQuery;
    }

    void setIdsByProjectQuery(String idsByProjectQuery) {
        this.idsByProjectQuery = idsByProjectQuery;
    }

    void setIdsBySelectionQuery(String idsBySelectionQuery) {
        this.idsBySelectionQuery = idsBySelectionQuery;
    }

    void setRequirementVersionDataQuery(String requirementVersionDataQuery) {
        this.requirementVersionDataQuery = requirementVersionDataQuery;
    }

    void setFolderDataQuery(String folderDataQuery) {
        this.folderDataQuery = folderDataQuery;
    }

    void setProjectDataQuery(String projectDataQuery) {
        this.projectDataQuery = projectDataQuery;
    }

    void setBoundTCDataQuery(String boundTCDataQuery) {
        this.boundTCDataQuery = boundTCDataQuery;
    }

    public void setCufsDataQuery(String cufsDataQuery) {
        this.cufsDataQuery = cufsDataQuery;
    }

    public void setRtfCufsDataQuery(String rtfCufsDataQuery) {
        this.rtfCufsDataQuery = rtfCufsDataQuery;
    }

    public void setNumCufsDataQuery(String numCufsDataQuery) {
        this.numCufsDataQuery = numCufsDataQuery;
    }

    public void setTagCufsDataQuery(String tagCufsDataQuery) {
        this.tagCufsDataQuery = tagCufsDataQuery;
    }

    public void setReqLinkDataQuery(String reqLinkDataQuery) {
        this.reqLinkDataQuery = reqLinkDataQuery;
    }

    public void setIdsByTagQuery(String idsByTagQuery) {
        this.idsByTagQuery = idsByTagQuery;
    }

    void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    void setIdsByMilestoneQuery(String idsByMilestoneQuery) {
        this.idsByMilestoneQuery = idsByMilestoneQuery;
    }

    Collection<Long> findIdsByProject(Collection<String> projectStrIds, Boolean printOnlyLastVersion) {
        String query = "";
        if (projectStrIds == null) {
            HashMap params = new HashMap();
            query = printOnlyLastVersion != false ? this.lastVersionIdsForAllProjectsQuery : this.idsForAllProjectsQuery;
            List foundStrIds = this.runner.executeSelect(query, params);
            return this.toIdList(foundStrIds);
        }
        if (projectStrIds.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<Long> projectIds = this.toIdList(projectStrIds);
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
        params.put("projectIds", projectIds);
        query = printOnlyLastVersion != false ? this.lastVersionIdsByProjectQuery : this.idsByProjectQuery;
        List foundStrIds = this.runner.executeSelect(query, params);
        return this.toIdList(foundStrIds);
    }

    Collection<Long> findIdsBySelection(Collection<String> ids, Boolean printOnlyLastVersion) {
        LinkedList<Long> versionIds = new LinkedList();
        if (ids != null && !ids.isEmpty()) {
            HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
            params.put("nodeIds", this.toIdList(ids));
            String query = printOnlyLastVersion != false ? this.lastVersionIdsBySelectionQuery : this.idsBySelectionQuery;
            List foundStrIds = this.runner.executeSelect(query, params);
            versionIds.addAll(this.toIdList(foundStrIds));
        } else {
            versionIds = new ArrayList();
        }
        return versionIds;
    }

    Collection<Long> findIdsByMilestone(Collection<String> milestoneIds, Boolean printOnlyLastVersion) {
        if (!milestoneIds.isEmpty()) {
            HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
            params.put("milestones", this.toIdList(milestoneIds));
            String query = printOnlyLastVersion != false ? this.lastVersionIdsByMilestoneQuery : this.idsByMilestoneQuery;
            List foundIds = this.runner.executeSelect(query, params);
            return this.toIdList(foundIds);
        }
        return Collections.emptyList();
    }

    public Collection<Long> findIdsByTags(List<String> tags, Boolean printOnlyLastVersion) {
        if (!tags.isEmpty()) {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("tags", tags);
            String query = printOnlyLastVersion != false ? this.lastVersionIdsByTagQuery : this.idsByTagQuery;
            List foundIds = this.runner.executeSelect(query, params);
            return this.toIdList(foundIds);
        }
        return Collections.emptyList();
    }

    Collection<Object[]> getReqVersionsDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.requirementVersionDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getTestCasesDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.boundTCDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getCufsDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.cufsDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getRtfCufsDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.rtfCufsDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getNumCufsDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.numCufsDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getFoldersDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.folderDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getProjectDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.projectDataQuery, VERSION_IDS, requirementIds);
    }

    public Collection<Object[]> getTagCufsDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.tagCufsDataQuery, VERSION_IDS, requirementIds);
    }

    public Collection<Object[]> getreqLinkDataQueryForReqIds(Collection<Long> requirementIds) {
        return this.execute(this.reqLinkDataQuery, VERSION_IDS, requirementIds);
    }

    String getMilestoneLabel(Integer milestoneId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("milestoneId", milestoneId);
        return (String)this.runner.executeUniqueSelect(SQL_FIND_MILESTONE_LABEL, params);
    }

    private Collection<Object[]> execute(String query, String paramName, Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
        params.put(paramName, ids);
        return this.runner.executeSelect(query, params);
    }

    protected Collection<Long> toIdList(Collection<?> ids) {
        return CollectionUtils.collect(ids, (Transformer)new IdTransformer());
    }

    public Collection<Object[]> getTagCufsDataForReqIds(Collection<Long> requirementIds) {
        return this.execute(this.tagCufsDataQuery, "requirementIds", requirementIds);
    }

    private static class IdTransformer
    implements Transformer {
        private IdTransformer() {
        }

        public Object transform(Object arg0) {
            Class<?> argClass = arg0.getClass();
            if (argClass.equals(String.class)) {
                return Long.valueOf((String)arg0);
            }
            if (argClass.equals(BigInteger.class)) {
                return ((BigInteger)arg0).longValue();
            }
            if (argClass.equals(Integer.class)) {
                return ((Integer)arg0).longValue();
            }
            throw new RuntimeException("bug : IdTransformer cannto convert items of class " + argClass.getName());
        }
    }
}

