/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.repository.SqlQueryRunner;
import org.squashtest.tm.plugin.report.books.requirements.dto.CufData;
import org.squashtest.tm.plugin.report.books.requirements.dto.Data;
import org.squashtest.tm.plugin.report.books.requirements.dto.FolderData;
import org.squashtest.tm.plugin.report.books.requirements.dto.ProjectData;
import org.squashtest.tm.plugin.report.books.requirements.dto.ReqLinkData;
import org.squashtest.tm.plugin.report.books.requirements.dto.RequirementVersionData;
import org.squashtest.tm.plugin.report.books.requirements.dto.TestCaseData;
import org.squashtest.tm.plugin.report.books.requirements.query.RequirementTreeQueryFinder;
import org.squashtest.tm.plugin.report.books.requirements.query.RequirementTreeQueryFormatter;

public class RequirementsTreeQuery
implements ReportQuery,
InitializingBean {
    private static Map<Resource, String> cache = new HashMap<Resource, String>();
    private static final String MILESTONES = "milestones";
    private static final String REQUIREMENTS_IDS = "requirementsIds";
    private static final String PROJECT_IDS = "projectIds";
    private static final String REQUIREMENTS_SELECTION_MODE = "requirementsSelectionMode";
    private static final String REQUIREMENT_FOLDERS = "requirement-folders";
    private static final String REQUIREMENTS = "requirements";
    private static final Object TAGS = "tags";
    private RequirementTreeQueryFinder queryFinder = new RequirementTreeQueryFinder();
    private RequirementTreeQueryFormatter formatter = new RequirementTreeQueryFormatter();
    protected SqlQueryRunner runner;

    public void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    public void afterPropertiesSet() throws Exception {
        this.queryFinder.setRunner(this.runner);
        this.formatter.setQueryFinder(this.queryFinder);
    }

    public void executeQuery(Map<String, Criteria> crit, Map<String, Object> res) {
        Collection<Long> versionIds = this.getReqVersionIdList(crit);
        Collection<Object[]> rawFolderData = this.queryFinder.getFoldersDataForVersionIds(versionIds);
        Collection<Object[]> rawProjectData = this.queryFinder.getProjectDataForVersionIds(versionIds);
        Collection<Object[]> rawReqVersionData = this.queryFinder.getReqVersionsDataForVersionIds(versionIds);
        Collection<Object[]> rawBoundTCData = this.queryFinder.getTestCasesDataForVersionIds(versionIds);
        Collection<Object[]> rawCufData = this.queryFinder.getCufsDataForVersionIds(versionIds);
        Collection<Object[]> rawRtfCufData = this.queryFinder.getRtfCufsDataForVersionIds(versionIds);
        Collection<Object[]> rawNumCufData = this.queryFinder.getNumCufsDataForVersionIds(versionIds);
        Collection<Object[]> rawtagCufData = this.queryFinder.getTagCufsDataForVersionIds(versionIds);
        Collection<Object[]> rawreqLinkData = this.queryFinder.getreqLinkDataQueryForReqIds(versionIds);
        Collection<ProjectData> projectDataList = this.formatter.toProjectData(rawProjectData);
        Collection<FolderData> folderDataList = this.formatter.toFolderData(projectDataList, rawFolderData);
        Collection<TestCaseData> testCaseDataList = this.formatter.toTestCaseData(rawBoundTCData);
        Collection<CufData> cufDataList = this.formatter.toCufData(rawCufData);
        Collection<CufData> rtfCufDataList = this.formatter.toCufData(rawRtfCufData);
        Collection<CufData> numCufDataList = this.formatter.toCufData(rawNumCufData);
        Collection<CufData> tagCufDataList = this.formatter.toMultipleValueCufData(rawtagCufData);
        Collection<RequirementVersionData> versionDataList = this.formatter.toRequirementVersionData(rawReqVersionData);
        Collection<ReqLinkData> reqLinkDataList = this.formatter.toReqLinkData(rawreqLinkData);
        this.formatter.bindAllData(projectDataList, folderDataList, versionDataList, testCaseDataList, cufDataList, rtfCufDataList, numCufDataList, tagCufDataList, reqLinkDataList);
        String milestoneLabel = null;
        if (this.isMilestonePicker(crit)) {
            List milestoneIds = (List)crit.get(MILESTONES).getValue();
            milestoneLabel = this.queryFinder.getMilestoneLabel((Integer)milestoneIds.get(0));
            res.put("milestoneLabel", milestoneLabel);
        }
        ArrayList<String> html = new ArrayList<String>();
        this.processRichText(projectDataList, folderDataList, html);
        Data data = new Data(projectDataList, milestoneLabel);
        res.put("data", data);
        res.put("fileName", data.getViewTitleRequirementsReport());
        res.put("data", data);
        res.put("html", html);
    }

    private void processRichText(Collection<ProjectData> projectDataList, Collection<FolderData> folderDataList, List<String> html) {
        for (ProjectData project : projectDataList) {
            for (RequirementVersionData req : project.getRequirements()) {
                if (req.hasParentFolder()) {
                    this.folderDescriptionForReq(req, folderDataList, html);
                }
                req.setDescription(this.richTextReplace(req.getDescription(), html));
                this.richTextForCuf(req.getRtfCufs(), html);
            }
        }
    }

    private void folderDescriptionForReq(RequirementVersionData req, Collection<FolderData> folderDataList, List<String> html) {
        for (FolderData folder : folderDataList) {
            if (folder.getDescription() == null || !folder.getFolderId().equals(req.getParentFolderId())) continue;
            req.setPathDescription(this.richTextReplace(folder.getDescription(), html));
        }
    }

    private void richTextForCuf(List<CufData> cufs, List<String> html) {
        for (CufData cuf : cufs) {
            cuf.setValue(this.richTextReplace(cuf.getValue(), html));
        }
    }

    private String richTextReplace(String string, List<String> html) {
        StringBuilder sb = new StringBuilder(string);
        sb.insert(0, "<html>");
        sb.append("</html>");
        String newVal = "<w:altChunk r:id='toto" + html.size() + "'/>";
        html.add(sb.toString());
        return newVal;
    }

    public void setIdsByProjectQuery(Resource idsByProjectQuery) {
        String query = RequirementsTreeQuery.loadQuery(idsByProjectQuery);
        this.queryFinder.setIdsByProjectQuery(query);
    }

    public void setLastVersionIdsByProjectQuery(Resource lastVersionIdsByProjectQuery) {
        String query = RequirementsTreeQuery.loadQuery(lastVersionIdsByProjectQuery);
        this.queryFinder.setLastVersionIdsByProjectQuery(query);
    }

    public void setIdsByTagQuery(Resource idsByTagQuery) {
        String query = RequirementsTreeQuery.loadQuery(idsByTagQuery);
        this.queryFinder.setIdsByTagQuery(query);
    }

    public void setLastVersionIdsByTagQuery(Resource lastVersionIdsByTagQuery) {
        String query = RequirementsTreeQuery.loadQuery(lastVersionIdsByTagQuery);
        this.queryFinder.setLastVersionIdsByTagQuery(query);
    }

    public void setIdsForAllProjectsQuery(Resource idsForAllProjectsQuery) {
        String query = RequirementsTreeQuery.loadQuery(idsForAllProjectsQuery);
        this.queryFinder.setIdsForAllProjectsQuery(query);
    }

    public void setLastVersionIdsForAllProjectsQuery(Resource lastVersionIdsForAllProjectsQuery) {
        String query = RequirementsTreeQuery.loadQuery(lastVersionIdsForAllProjectsQuery);
        this.queryFinder.setLastVersionIdsForAllProjectsQuery(query);
    }

    public void setIdsBySelectionQuery(Resource idsBySelectionQuery) {
        String query = RequirementsTreeQuery.loadQuery(idsBySelectionQuery);
        this.queryFinder.setIdsBySelectionQuery(query);
    }

    public void setLastVersionIdsBySelectionQuery(Resource lastVersionIdsBySelectionQuery) {
        String query = RequirementsTreeQuery.loadQuery(lastVersionIdsBySelectionQuery);
        this.queryFinder.setLastVersionIdsBySelectionQuery(query);
    }

    public void setIdsByMilestoneQuery(Resource idsByMilestoneQuery) {
        String query = RequirementsTreeQuery.loadQuery(idsByMilestoneQuery);
        this.queryFinder.setIdsByMilestoneQuery(query);
    }

    public void setLastVersionIdsByMilestoneQuery(Resource lastVersionIdsByMilestoneQuery) {
        String query = RequirementsTreeQuery.loadQuery(lastVersionIdsByMilestoneQuery);
        this.queryFinder.setLastVersionIdsByMilestoneQuery(query);
    }

    public void setRequirementVersionDataQuery(Resource requirementVersionDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(requirementVersionDataQuery);
        this.queryFinder.setRequirementVersionDataQuery(query);
    }

    public void setFolderDataQuery(Resource folderDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(folderDataQuery);
        this.queryFinder.setFolderDataQuery(query);
    }

    public void setProjectDataQuery(Resource projectDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(projectDataQuery);
        this.queryFinder.setProjectDataQuery(query);
    }

    public void setBoundTCDataQuery(Resource boundTCDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(boundTCDataQuery);
        this.queryFinder.setBoundTCDataQuery(query);
    }

    public void setCufsDataQuery(Resource cufsDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(cufsDataQuery);
        this.queryFinder.setCufsDataQuery(query);
    }

    public void setRtfCufsDataQuery(Resource rtfCufsDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(rtfCufsDataQuery);
        this.queryFinder.setRtfCufsDataQuery(query);
    }

    public void setNumCufsDataQuery(Resource numCufsDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(numCufsDataQuery);
        this.queryFinder.setNumCufsDataQuery(query);
    }

    public void setTagCufsDataQuery(Resource tagCufsDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(tagCufsDataQuery);
        this.queryFinder.setTagCufsDataQuery(query);
    }

    public void setReqLinkDataQuery(Resource reqLinkDataQuery) {
        String query = RequirementsTreeQuery.loadQuery(reqLinkDataQuery);
        this.queryFinder.setReqLinkDataQuery(query);
    }

    protected SqlQueryRunner getRunner() {
        return this.runner;
    }

    private Collection<Long> getReqVersionIdList(Map<String, Criteria> criteriaMap) {
        Collection<Long> requirementIdList;
        Criteria selectionMode = criteriaMap.get(REQUIREMENTS_SELECTION_MODE);
        HashMap<String, Boolean> optionsMap = new HashMap<String, Boolean>();
        Criteria options = criteriaMap.get("reportOptions");
        optionsMap.put("printOnlyLastVersion", false);
        Collection selectedOptions = (Collection)options.getValue();
        for (String option : selectedOptions) {
            optionsMap.put(option, true);
        }
        Boolean printOnlyLastVersion = (Boolean)optionsMap.get("printOnlyLastVersion");
        if ("PROJECT_PICKER".equals(selectionMode.getValue())) {
            Criteria criteria = criteriaMap.get(PROJECT_IDS);
            Collection projectIds = (Collection)criteria.getValue();
            requirementIdList = this.queryFinder.findIdsByProject(projectIds, printOnlyLastVersion);
        } else if ("MILESTONE_PICKER".equals(selectionMode.getValue())) {
            List milestoneIds = (List)criteriaMap.get(MILESTONES).getValue();
            requirementIdList = this.queryFinder.findIdsByMilestone(milestoneIds, printOnlyLastVersion);
        } else if ("TAG_PICKER".equals(selectionMode.getValue())) {
            List tags = (List)criteriaMap.get(TAGS).getValue();
            requirementIdList = this.queryFinder.findIdsByTags(tags, printOnlyLastVersion);
        } else {
            ArrayList folderIds;
            Criteria criteria = criteriaMap.get(REQUIREMENTS_IDS);
            Map selectedIds = (Map)criteria.getValue();
            ArrayList<String> allStrIds = (ArrayList<String>)selectedIds.get(REQUIREMENTS);
            if (allStrIds == null) {
                allStrIds = new ArrayList<String>();
            }
            if ((folderIds = (ArrayList)selectedIds.get(REQUIREMENT_FOLDERS)) == null) {
                folderIds = new ArrayList();
            }
            allStrIds.addAll(folderIds);
            requirementIdList = this.queryFinder.findIdsBySelection(allStrIds, printOnlyLastVersion);
        }
        return requirementIdList;
    }

    private boolean isMilestonePicker(Map<String, Criteria> criteriaMap) {
        Criteria selectionMode = criteriaMap.get(REQUIREMENTS_SELECTION_MODE);
        return "MILESTONE_PICKER".equals(selectionMode.getValue());
    }

    protected static String loadQuery(Resource query) {
        if (cache.get(query) == null) {
            InputStream is;
            try {
                is = query.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Scanner scan = new Scanner(is, "UTF-8");
            String value = scan.useDelimiter("\\A").next();
            scan.close();
            cache.put(query, value);
        }
        return cache.get(query);
    }
}

