/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.qualitativecoverage.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.io.Resource;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageProjectBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.AbstractItemProcess;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageCampaignProcess;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QueryContext;

public class QuaCoverageProcess
extends AbstractItemProcess {
    private List<QuaCoverageProjectBean> projectBeans;
    private Collection<Integer> milestoneIds;

    public List<QuaCoverageProjectBean> getProjects(QueryContext ctx, Collection<String> projectIds) {
        this.projectBeans = new ArrayList<QuaCoverageProjectBean>();
        for (String id : projectIds) {
            HashMap<String, Long> parameters = new HashMap<String, Long>();
            Long idAsLong = this.evaluateExpressionToLong(id);
            parameters.put("id", idAsLong);
            List result = ctx.getRunner().executeSelect(this.loadQuery((Resource)ctx.get("projectsById")), parameters);
            this.convertResultToProjectBean(result, ctx);
        }
        return this.projectBeans;
    }

    private void convertResultToProjectBean(List<Object[]> result, QueryContext ctx) {
        for (Object[] row : result) {
            QuaCoverageProjectBean projectBean = new QuaCoverageProjectBean();
            projectBean.setProjectId(this.evaluateExpressionToLong(row[0]));
            projectBean.setProjectName(this.evaluateExpressionToString(row[1]));
            QuaCoverageCampaignProcess campaignProcess = new QuaCoverageCampaignProcess();
            campaignProcess.setMilestoneIds(this.milestoneIds);
            projectBean.setCampaigns(campaignProcess.getCampaigns(ctx, projectBean.getProjectId()));
            List<String> disabledExecutionStatus = this.getDisabledExecutionStatus(ctx, projectBean.getProjectId());
            projectBean.setDisabledExecutionStatus(disabledExecutionStatus);
            if (projectBean.getCampaigns().isEmpty()) continue;
            this.projectBeans.add(projectBean);
        }
    }

    public void setMilestoneIds(Collection<Integer> milestoneIds) {
        this.milestoneIds = milestoneIds;
    }

    private List<String> getDisabledExecutionStatus(QueryContext ctx, Long projectId) {
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("id", projectId);
        List disabledExecutionStatus = ctx.getRunner().executeSelect(this.loadQuery((Resource)ctx.get("projectDisabledStatuses")), parameters);
        return disabledExecutionStatus;
    }
}

